<?php
    include 'client/minifier.php';
    //ob_start();
?>

<?php
    require_once 'client/bingc.lib.php';
    include 'config.php';

    global $CFG;

    $request_type = ""; // used in decide on the include page
    $page_title = $CFG->site_meta_title;
    $page_desc = $CFG->site_meta_desc;
    $page_keywords = $CFG->site_meta_keywords;
    $page_desc = $CFG->site_meta_desc;

    $content_title = '';
    $content_html = '';
    $response = '';

    $history = '';

    // add to history
    $bclient = new bingc\client();
    
    //*** Jan 12th 2019
	// this code is for getting geo info (country) for a given client ip (used for displaying sb ads)
	// IMPORTANT - this code does not return data for local IP (local testing)
	$geo_info = $bclient->get_geoip_info($_SERVER['REMOTE_ADDR'], $CFG->site_type, $_SERVER['HTTP_HOST']);

	// for testing
	//$geo_info = $bclient->get_geoip_info('43.224.158.176', 'cp', $_SERVER['HTTP_HOST']);

	//echo $geo_info['data']['log'];
	//debug_to_console($geo_info['data']);
	// Jan 12th 2019 ***//

	/* ***** 302 redirect is disabled to ensure little impact to search urls; instead using below if blog to process old url param requests as them are without redirecting
    if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) { // make sure there is no html or echo before 301 redirect

        debug_to_console("client - keyword is " . $_GET[$CFG->old_search_param]);
        // check if keyword is valid and also get slug to use in the url
        $response = $bclient->check_keyword($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST']);

        //echo 'log ' . $response['data']['log'];
        debug_to_console($response['data']);

        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {

                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {

                $url = $CFG->site_search_uri . $response['data']['query']['keyword']['slug'];
                debug_to_console('client - redirect to ' . $url);
                header("HTTP/1.1 301 Moved Permanently");
                header("Location: $url");
            }
        }
        else {
                debug_to_console('client - unauthorised request');
                header("Location: $CFG->unauth_search_url");
        }
    }
	*/
	if (isset($_GET[$CFG->old_search_param]) && trim($_GET[$CFG->old_search_param] != '')) {  // THIS condition to bypass 302 redirect commented above (temporary)

		$request_type = 'search'; // include

		if(strlen($_GET[$CFG->old_search_param]) <= $CFG->wscp_name_max_length) {
			$response = $bclient->get($_GET[$CFG->old_search_param], $CFG->site_type, $_SERVER['HTTP_HOST'], $geo_info);
		}

		//echo $response['data']['log'];
		debug_to_console('client - logging entire response');
		debug_to_console($response);

		if (isset($response['data']['results'])) {
			debug_to_console($response['data']['results']);
		}
		debug_to_console('client - 1');

		// check if it is authorised request (query/keyword will be set)
		if(isset($response['data']['query'])) {

			if (!$response['data']['query']['keyword']['is_valid']) {
				debug_to_console('client - keyword is not valid');
				header("Location: $CFG->invalid_search_url");

			} else {
				debug_to_console('client - 2 else');
				$page_title = $response['data']['query']['keyword']['title_text'].' Worksheets';
                $content_title = $response['data']['query']['keyword']['title_text'];

				// this is to show related related search results
				if ($CFG->show_related_ws) {
					// used in related search
					$content_slug = $response['data']['query']['keyword']['slug'];
					$ascga_rs_json = file_get_contents($CFG->asc_ga_related_search_service_url . 'search_in=file&key=' . $content_slug);
					$ascga_rs_a = json_decode($ascga_rs_json, true);
				}

                // new page desc code improve seo
                $clean_piped_titles = $bclient->clean_result_titles($response);
				$page_desc_str = $content_title . ' Worksheets - showing all ' . count($response['data']['results']).' printables. ';
                $page_desc_str .= 'Worksheets are ' .  str_replace('|', ', ', $clean_piped_titles) . '.';
                $page_desc = substr($page_desc_str, 0, strpos($page_desc_str, ' ', 160)) . '...';

                $page_keywords = $response['data']['query']['keyword']['clean_text'];

				if(isset($response['data']['results']) && count($response['data']['results']) > 0) {
					debug_to_console('client - 3 else before add history');
					$bclient->add_to_history($response['data']['query']['keyword']['title_text'] . '|' . $response['data']['query']['keyword']['slug']);
					debug_to_console('client - 4 else end');
				}
			}
		}
		else {
			debug_to_console('client - unauthorised request');
			header("Location: $CFG->unauth_search_url");
		}
	}
    else if (isset($_GET['s'])) {  // this param is set in .htaccess file as part of url rewrite

        $request_type = 'search'; // include
        //echo '[s-condition]keyword: ' . $_GET['s']."<br>";

        if(strlen($_GET['s']) <= $CFG->wscp_name_max_length) {
                $response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST'], $geo_info);
        }
        //$response = $bclient->get($_GET['s'], $CFG->site_type, $_SERVER['HTTP_HOST'], $geo_info);

        //echo $response['data']['log'];
        debug_to_console('client - logging entire response');
        debug_to_console($response);

        if (isset($response['data']['results'])) {
            debug_to_console($response['data']['results']);
        }
	debug_to_console('client - 1');
        // check if it is authorised request (query/keyword will be set)
        if(isset($response['data']['query'])) {

            if (!$response['data']['query']['keyword']['is_valid']) {
                debug_to_console('client - keyword is not valid');
                header("Location: $CFG->invalid_search_url");

            } else {
                debug_to_console('client - 2 else');

                $page_title = $response['data']['query']['keyword']['title_text'].' Worksheets';
                $content_title = $response['data']['query']['keyword']['title_text'];

                // this is to show related related search results
                if ($CFG->show_related_ws) {
                        // used in related search
                        $content_slug = $response['data']['query']['keyword']['slug'];
                        $ascga_rs_json = file_get_contents($CFG->asc_ga_related_search_service_url . 'search_in=file&key=' . $content_slug);
                        $ascga_rs_a = json_decode($ascga_rs_json, true);
                }

                // new page desc code improve seo
                $clean_piped_titles = $bclient->clean_result_titles($response);
                $page_desc_str = $content_title . ' Worksheets - showing all ' . count($response['data']['results']).' printables. ';
                $page_desc_str .= 'Worksheets are ' .  str_replace('|', ', ', $clean_piped_titles) . '.';
                $page_desc = substr($page_desc_str, 0, strpos($page_desc_str, ' ', 160)) . '...';

                $page_keywords = $response['data']['query']['keyword']['clean_text'];

				if(isset($response['data']['results']) && count($response['data']['results']) > 0) {
					debug_to_console('client - 3 else before add history');
					$bclient->add_to_history($response['data']['query']['keyword']['title_text'] . '|' . $response['data']['query']['keyword']['slug']);
					debug_to_console('client - 4 else end');
				}
            }
        }
        else {
            debug_to_console('client - unauthorised request');
            //header("Location: $CFG->unauth_search_url");
        }

    }
    else if (isset($_GET['p'])) { // this param is set in .htaccess file as part of url rewrite
        $request_type = 'page'; // include content.php
        //echo 'page: ' . $_GET['p'];

        $content = file_get_contents($CFG->site_content_json);
        $cname = $_GET['p'];
        $json_a = json_decode($content, true);
        //var_dump(json_decode($content, true));

        if (isset($json_a['categories'][$cname])) {
            //echo "content name: " . $json_a['categories'][$cname]['title'];
            $page_title = $json_a['categories'][$cname]['title'];
            $page_desc = $json_a['categories'][$cname]['title'];
            $page_keywords = $json_a['categories'][$cname]['title'];

            $content_title = $json_a['categories'][$cname]['title'];
            $content_html = $json_a['categories'][$cname]['html'];
        }
        else {
            debug_to_console('client - site content data not found');
            debug_to_console('client - unauthorised request');
            header("Location: $CFG->unauth_search_url");

        }
    }
	else if (isset($_GET['ccd'])) { // this param is set in .htaccess file as part of url rewrite

        debug_to_console('ccd:'. $_GET['ccd'] .' id:'. $_GET['id'] .'curriculum:'. $_GET['cu']);
        //common core home
		$request_type = 'cc'; // include cc_content.php
        $cc_page = 'home'; // display main landing page for common core

        $cc_domain = $_GET['ccd'];
        $cc_grade = $_GET['g'];
        $cc_id = $_GET['id'];
        $cc_cu = $_GET['cu'];

		// remove '-' for title
		$cc_domain_t = str_replace('-', ' ', ucfirst($cc_domain));
		$cc_grade_t = str_replace('-', ' ', ucfirst($cc_grade));
		$cc_cu_t = str_replace('-', ' ', ucfirst($cc_cu));

		$cc_content = '';
        if ($cc_domain === 'ela') {
        	$cc_content = file_get_contents($CFG->cc_ela_content_json);

        } else if ($cc_domain === 'math') {
            $cc_content = file_get_contents($CFG->cc_math_content_json);
        }

        $cc_json_a = json_decode($cc_content, true);
		//echo json_last_error_msg(); // used only for debugging json

        if ($cc_domain === 'home') {
            $cc_page ='home';
            $page_title = 'Common Core Worksheets';
            $page_desc = 'Worksheets based on US Common Core standards';
            $page_keywords = 'common core, us, curriculum, ela, math, english, literature, arts';
        }
        else if (in_array($cc_domain, array('ela', 'math')) && isset($cc_grade)) {
            $cc_page ='grade';
            $page_title = 'Common Core '. $cc_domain_t . ' ' . $cc_grade_t;
            $page_desc = 'Common Core '. $cc_domain_t .' '. $cc_grade_t;
            $page_keywords = $cc_grade.', common core, us, curriculum, ela, math, english, literature, arts';
        }
        else if (in_array($cc_domain, array('ela', 'math')) && isset($cc_id)) {
            $cc_page ='id';
			$topic = $cc_json_a[$cc_domain][$cc_id];
			$title_t = preg_replace('/[^a-z0-9]/i', ' ', $topic['page_title']);
            $page_title = 'Common Core ' . $title_t;
            $page_desc = 'Common Core ' . $topic['page_title'];
            $page_keywords = $cc_id.', '.str_replace('-', ', ', $cc_cu).', common core, us, curriculum, ela, math, english, literature, arts';
        }
		else {
			debug_to_console('client - unauthorised request');
			header("Location: $CFG->unauth_search_url");
		}
	}
	else if (isset($_GET['curr_page'])) { // this param is set in .htaccess file as part of url rewrite
		$request_type = 'curriculum'; // include curr_content.php
		$curr_meta = file_get_contents($CFG->curriculum_root . '/' . $_GET['curr_country'] . '.json');
		$curr_meta_a = json_decode($curr_meta, true);

		$curr_item = $curr_meta_a[$_GET['curr_country']][$_GET['curr_page']];

		$curr_index = '/curriculum/' . $_GET['curr_country'];

		//echo 'json-' . $cur_meta;
		//echo 'meta path -->' . $CFG->curriculum_root . '/' . $_GET['curr_country'] . '.json' . '  curr page -->' . $_GET['curr_page'];
		//var_dump($curr_item);

		$page_title = $curr_item['page_title'];

		$page_desc_str = $curr_item['page_desc'];
		$page_desc = substr($page_desc_str, 0, strpos($page_desc_str, ' ', 160)) . '...';

		$page_keywords = $curr_item['page_keywords'];

	}
	else if (isset($_GET['contact-us'])) {
		$request_type = 'contact-us';
	}
    else {
        $request_type = '';
    }
    
    $hlinks = $bclient->get_history_links();
    $hlinks = str_replace($CFG->site_url, '', $hlinks);
    $hlinks = str_replace('<p>', '<div class="d-flex flex-wrap"><ol class="list-group list-group-flush">', $hlinks);
    $hlinks = str_replace('<a ', '<li class="list-group-item p-1"><a class="d-flex flex-wrap" ', $hlinks);
    $hlinks = str_replace('</a>', '</li></a>', $hlinks);
    $hlinks = str_replace('</p>', '</ol></div>', $hlinks);
    $hlinks = str_replace('|', '', $hlinks);
    //$hlinks = str_replace('">', '" class="border rounded px-1 mx-1 mb-4">', $hlinks);
    //$hlinks = str_replace('|', '', $hlinks);
    //debug_to_console($hlinks);
    //echo $hlinks;
							?>

?>

<!DOCTYPE html>

<html class="loading" lang="en" data-textdirection="ltr">
<!-- BEGIN: Head-->

<head>
    <meta http-equiv="Content-Type" content="text/html; charset=UTF-8">
    <meta http-equiv="X-UA-Compatible" content="IE=edge">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, user-scalable=0, minimal-ui">
    <meta name="description" content="<?php echo $page_desc; ?>">
    <meta name="keywords" content="<?php echo $page_keywords; ?>">
    <meta name="author" content="PrintableWorksheets">
    <title><?php echo $page_title.' - '. $CFG->site_meta_title_suffix; ?></title>
    <link rel="apple-touch-icon" href="<?php echo $CFG->cdn_domain; ?>/logo-120.png">
    <link rel="shortcut icon" type="image/x-icon" href="<?php echo $CFG->cdn_domain; ?>/favicon.ico">
    <link href="<?php echo $CFG->cdn_domain; ?>/favicon.ico" rel="shortcut icon" type="image/vnd.microsoft.icon" />
    <meta name="google-site-verification" content="NRtg_BVKDZDBnr8kw8tn5-eLc5UqyQ0CMBhd4-T2Fnk" />
    <link href="https://fonts.googleapis.com/css?family=Montserrat:300,300i,400,400i,500,500i%7COpen+Sans:300,300i,400,400i,600,600i,700,700i" rel="stylesheet">

    <!-- BEGIN: Vendor CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/vendors/css/vendors.min.css">
    <!-- END: Vendor CSS-->

    <!-- BEGIN: Theme CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/bootstrap.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/bootstrap-extended.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/colors.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/components.min.css">
    <!-- END: Theme CSS-->

    <!-- BEGIN: Page CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/core/menu/menu-types/vertical-menu.min.css">
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/app-assets/css/core/colors/palette-gradient.min.css">
    <!-- END: Page CSS-->

    <!-- BEGIN: Custom CSS-->
    <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/assets/css/style.css">
    <!-- END: Custom CSS-->
    
    <!-- Custom CSS: You can use this stylesheet to override any Bootstrap styles and/or apply your own styles -->
    <link href="<?php echo $CFG->cdn_domain; ?>/css/custom.css" rel="stylesheet">

    <?php echo $CFG->g_analytics_script; ?>
    <?php echo $CFG->g_page_ad_script; ?>

</head>
<!-- END: Head-->

<!-- BEGIN: Body-->

<body class="vertical-layout vertical-menu detached-right-sidebar container boxed-layout fixed-navbar container boxed-layout" data-open="click" data-menu="vertical-menu" data-col="content-detached-right-sidebar">

    <!-- BEGIN: Header-->
    <?php include 'includes/navbar.php' ?>
    <!-- END: Header-->


    <!-- BEGIN: Main Menu-->
    <!-- main menu-->
    <div class="main-menu menu-fixed menu-light menu-accordion menu-bordered menu-shadow" data-scroll-to-active="true">
        <!-- main menu header-->
        <!-- / main menu header-->
        <!-- main menu content-->
        <?php include 'includes/main_menu_content.php' ?>
        <!-- /main menu content-->
        <!-- main menu footer-->
        <!-- main menu footer-->
    </div>
    <!-- / main menu-->
    <!-- END: Main Menu-->

    <!-- BEGIN: Content-->
    <!-- includes -->
    <?php
            if($request_type === 'search') {
                    include 'includes/sresults.php';
            }
            else if($request_type === 'page') {
                    include 'includes/content.php';
            }
            else if($request_type === 'cc') {
                    include 'includes/cc_content.php';
            }
            else if($request_type === 'curriculum') {
                    include 'includes/curr_content.php';
            }
            else if($request_type === 'contact-us') {
                    include 'lib/contactus/contact-form.php';
            }
            else {
                    //echo "redirecting to home";
                    include 'includes/home.php';
            }
    ?>
    <!-- END: Content-->
    <div class="sidenav-overlay"></div>
    <div class="drag-target"></div>

    <!-- BEGIN: Footer-->
    <?php include 'includes/footer.php' ?>
    <!-- END: Footer-->


    <!-- BEGIN: Vendor JS-->
    <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/vendors/js/vendors.min.js"></script>
    <!-- BEGIN Vendor JS-->

    <!-- BEGIN: Page Vendor JS-->
    <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/vendors/js/ui/jquery.sticky.js"></script>
    <!-- END: Page Vendor JS-->

    <!-- jquery lazy library -->
    <script src="<?php echo $CFG->cdn_domain; ?>/dist/jqueryui/1.12.0/jquery-ui.min.js"></script>
    <script src="<?php echo $CFG->cdn_domain; ?>/dist/jquery.lazy/1.7.10/jquery.lazy.min.js"></script>
    <script src="<?php echo $CFG->cdn_domain; ?>/dist/jquery.lazy/1.7.10/jquery.lazy.plugins.min.js"></script>

    <!-- BEGIN: Theme JS-->
    <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/core/app-menu.min.js"></script>
    <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/core/app.min.js"></script>
    <?php /* <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/scripts/customizer.js"></script> */ ?>
    <!-- END: Theme JS-->

    <!-- BEGIN: Page JS-->
    <script src="<?php echo $CFG->cdn_domain; ?>/app-assets/js/scripts/pages/sk-content-sidebar.js"></script>
    <!-- END: Page JS-->

    <!-- Initialize Bootstrap functionality -->
    <script>
	// Initialize Lazy load component
        $(function() {
            $('.lazy').lazy();
        });

        // Initialize tooltip component
        $(function () {
                $('[data-toggle="tooltip"]').tooltip()
        })

        // Initialize popover component
        $(function () {
                $('[data-toggle="popover"]').popover()
        })
    </script>
    
        <?php 
        if($request_type === 'contact-us') {
	?>
            <script>
                    $(document).ready(function (e){
                            $("#frmContact").on('submit',(function(e){
                                    e.preventDefault();
                                    $("#mail-status").hide();
                                    $('#send-message').hide();
                                    $('#loader-icon').show();
                                    $.ajax({
                                            url: "/lib/contactus/contact.php",
                                            type: "POST",
                                            dataType:'json',
                                            data: {
                                                    "name":$('input[name="name"]').val(),
                                                    "email":$('input[name="email"]').val(),
                                                    "country":$('input[name="country"]').val(),
                                                    "content":$('textarea[name="content"]').val(),
                                                    "g-recaptcha-response":$('textarea[id="g-recaptcha-response"]').val(),
                                                    "gcip": "<?php echo isset($geo_info['data']['ip']) ? $geo_info['data']['ip'] : 'NA'; ?>",
                                                    "gciso": "<?php echo isset($geo_info['data']['country_iso']) ? $geo_info['data']['country_iso'] : 'NA'; ?>",
                                                    "gcname": "<?php echo isset($geo_info['data']['country_name']) ? $geo_info['data']['country_name'] : 'NA'; ?>"},
                                            success: function(response){
                                                    $("#mail-status").show();
                                                    $('#loader-icon').hide();
                                                    if(response.type == "error") {
                                                            $('#send-message').show();
                                                            $("#mail-status").attr("class","error");
                                                    } else if(response.type == "message"){
                                                            $('#send-message').hide();
                                                            $("#mail-status").attr("class","success");
                                                    }
                                                    $("#mail-status").html(response.text);
                                            },
                                            error: function(){}
                                    });
                            }));
                    });
            </script>
	<?php
	}
	?>
	<?php 
        // search suggestions
	if(isset($CFG->show_search_suggestion) && $CFG->show_search_suggestion == true) {
	?>
            <script>
                    $(function() {
                            var sugg_url = "/client/suggest?q=";
                            $("#s").autocomplete({
                                    source : function(request, response) {
                                            var skey = $("#s").val();
                                            var URL = sugg_url + skey;
                                            $.ajax({
                                                    url : URL,
                                                    success : function(data) {
                                                            response($.map(data, function(value, key) {
                                                                    return {
                                                                            label : value.term
                                                                    }
                                                            })); // end response
                                                    },
                                                    dataType : 'jsonp',
                                                    jsonp : 'json.wrf'
                                            }); // end ajax
                                    }, // end source
                                    minLength : 1
                            }) // end autocompte
                    });
            </script>
	<?php
        } // end search suggestions
	?>	
	<?php
	//if(isset($geo_info['data']['country_iso']) && in_array($geo_info['data']['country_iso'], $CFG->eu_countries)) {
	?>
            <link rel="stylesheet" type="text/css" href="<?php echo $CFG->cdn_domain; ?>/dist/cookieconsent2/3.1.1/cookieconsent.min.css" />
            <script src="<?php echo $CFG->cdn_domain; ?>/dist/cookieconsent2/3.1.1/cookieconsent.min.js"></script>
            <script>
                    window.addEventListener("load", function(){
                            window.cookieconsent.initialise({
                                    "palette": {
                                            "popup": {
                                            "background": "#efefef",
                                            "text": "#404040"
                                    },
                                    "button": {
                                            "background": "#8ec760",
                                            "text": "#ffffff"
                            }
                    },
                    "theme": "classic",
                    "content": {
                            "message": "This website uses <a href='https://cookiesandyou.com' target='_blank'>cookies</a> as explained in our <a href='/privacy-policy' target='_blank'>privacy policy</a> notice to offer you a better browsing experience. ",
                            "link": "Learn more...",
                            "dismiss": "Got it!",
                            "href": "https://cookiesandyou.com"
                    }
                    })});
            </script>
	<?php
	//}
	?>
                
</body>
<!-- END: Body-->

</html>

<?php
    //$content = minify_html( ob_get_clean() );
    //echo $content;
?>